uniform vec2 center; 
uniform vec2 resolution;
uniform float time;
uniform vec2 mouse; 
uniform float pulse1;
uniform float pulse2;
uniform float pulse3; 


#define PI 3.14159265359
#define DEG2RAD PI/180.


#define SUPERSAMP 8


vec3 revProject(vec2 camPos, float worldY, float fov) {
    float worldZ = worldY / (camPos.y * tan(fov*DEG2RAD*.5));
    float worldX = worldY * camPos.x / camPos.y;
    return vec3(worldX, worldY, worldZ);
}

void main(){
    vec2 uv = gl_FragCoord / resolution.xy;
    vec2 p = (gl_FragCoord.xy - resolution.xy*.5) / resolution.y;
    
    
    float fragsize = 1. / resolution.y;
    float supersize = fragsize / float(SUPERSAMP);

    
    float horizonY = 0.2;
    
    
    if (p.y > horizonY) {
    	gl_FragColor = vec4(vec3(0.), 1.0);
    }
    else {
        
        float intensity = 0.;
        
        vec3 displace = vec3(3.*sin(2.*PI*0.1*time), 4.*time, 1.5);
        
        float fov = 90.0;
        
        
        for (int i = 0; i < SUPERSAMP; i++) {
            for (int j = 0; j < SUPERSAMP; j++) {
                vec2 superoffset = vec2(i,j) * supersize;
                
                vec2 gridPos = revProject(p + superoffset - vec2(0., horizonY), displace.z, fov).xz;                
                
                vec2 grid = fract(gridPos - displace.xy) - 0.5;
                
                float pattern = 0.7+0.6*sin(gridPos.y - 6.*time);
                
                
                float dist = max(grid.x*grid.x, grid.y*grid.y);
                
                float fade = min(1.5, pow(1.2, -length(gridPos) + 15.0));
                
                float bright = 0.015 / (0.26 - dist);
                intensity += fade * pattern * bright;
            }
        }
        
        
        vec3 col = 0.5 + 0.5*cos(time+p.yxy+vec3(0,10,20));
        
        intensity /= float(SUPERSAMP*SUPERSAMP);
        
    	gl_FragColor = vec4(intensity * col, 1.0);
    }
    
    gl_FragColor = pow(gl_FragColor, vec4(.4545));
}